<?php
session_start();

// Verificar si el usuario está logueado
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Conectar a la base de datos
require_once '../conexiones/conexion.php';

$error = '';
$success = '';

// Procesar el formulario
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Obtener el código del ticket enviado desde el formulario
    $codigo_ticket = $_POST['codigo_ticket'] ?? '';

    // Verificar si el código de ticket existe en la base de datos
    $stmt = $pdo->prepare("SELECT * FROM tickets WHERE codigo_ticket = ?");
    $stmt->execute([$codigo_ticket]);
    $ticket = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($ticket) {
        // Verificar si el ticket ya ha sido escaneado
        if ($ticket['estado'] === 'escaneado') {
            // Si el ticket ya está escaneado, mostrar mensaje de error
            $error = "Ticket no válido, ya ha sido escaneado.";
        } else {
            // Si el ticket no ha sido escaneado, cambiar el estado a "escaneado"
            $stmt = $pdo->prepare("UPDATE tickets SET estado = 'escaneado' WHERE codigo_ticket = ?");
            $stmt->execute([$codigo_ticket]);

            $success = "Ticket escaneado con éxito.";
        }
    } else {
        // Si el ticket no existe, mostrar un mensaje de error
        $error = "Ticket no encontrado.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resultado del Escaneo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center mb-4">Resultado del Escaneo</h1>

        <!-- Mostrar mensaje de éxito o error -->
        <?php if (!empty($error)) { echo "<div class='alert alert-danger'>$error</div>"; } ?>
        <?php if (!empty($success)) { echo "<div class='alert alert-success'>$success</div>"; } ?>

        <div class="d-grid mt-3">
            <a href="../scan_ticket.php" class="btn btn-primary">Escanear Otro Ticket</a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
